#	Zenith Air CH650 Simulation

#	Liveries
#	aircraft.livery.init("Aircraft/CH650/Models/Liveries");

#	Initialization
setlistener("/sim/signals/fdm-initialized", func{
	setprop("/controls/gear/brake-parking",1);
	setprop("/controls/gear/brake-parking-pos",1);
	setprop("/consumables/fuel/tank[1]/selected",1);
	print("Zenith Air CH650 loaded");
});

setlistener("/engines/engine/running", func(running) {
	var running = running.getBoolValue();
	if(running){ 
		interpolate("/engines/engine/oil-pressure-psi", 6, 0.9);
	}else{
		interpolate("/engines/engine/oil-pressure-psi", 0, 0.9);
	}
});

##############################################
######### AUTOSTART / AUTOSHUTDOWN ###########
##############################################

setlistener("/sim/model/start-idling", func(idle){
	var run= idle.getBoolValue();
	if(run){
		Startup();
	}else{
		Shutdown();
	}
},0,0);

var Startup = func {
	setprop("/controls/electric/key",1);
	setprop("/controls/engines/engine/magnetos",3);
	setprop("/engines/engine/rpm",2700);
	setprop("/engines/engine/running",1);
	setprop("/controls/gear/brake-parking",0);
}

var Shutdown = func {
	setprop("/controls/electric/key",0);
	setprop("/controls/engines/engine/magnetos",0);
	setprop("/engines/engine/rpm",0);
	setprop("/engines/engine/running",0);
	setprop("/controls/gear/brake-parking",1);
}

