# Nasal files to be loaded at start
# the order could be important as some files need other one to be loaded first
files_to_load = [
    'lib.nas',     # some useful functions, should stay first loaded
    'radios.nas',  # all about radios COMM, NAV, XPDR
    'knobs.nas',   # handles knobs
    'buttons.nas', # handles knobs and buttons
    'softkeys.nas',# handles softkeys and menus items
    'maps/route.nas',
    'maps/navaids.nas',
    'maps/tiles.nas',
    'maps/tcas.nas',
    'map.nas',     # moves the maps
    'display.nas',
    'menu.nas',    # manage windows
    'core.nas',    # the scheduler and switch on button
];
#    'afcs.nas',    # Automatic Flight Control System
#    'routes.nas',  # manages flightplans and routes
#    'display.nas', # display messages and popups
#    'infos.nas',   # get informations from environment
#    'alerts.nas',  # in flight tests
#    'mud.nas',     # displays simple embedded GUI (Multi-Use Display)

var flightdeck = {};

var data = { # set of data common to all devices
    roll : 0,
    pitch : 0,
    vsi : 0,
    ias : 0,
    alt : 0,
    hdg : 0,
    wow : 1,
    lat : 0,
    lon : 0,
    aoa : 0,
    tcas: [],
    timers : {
        '20Hz': maketimer (
            0.05,
            func {
                data.roll = getprop('/orientation/roll-deg');
                data.pitch = getprop('orientation/pitch-deg');
                data.vsi = getprop('/instrumentation/vertical-speed-indicator/indicated-speed-fpm');
                data.ias = getprop('/velocities/airspeed-kt');
                data.alt = getprop('/instrumentation/altimeter/indicated-altitude-ft');
                data.hdg = getprop('/orientation/heading-deg');
                data.aoa = getprop('/orientation/alpha-deg');
            }
        ),
        '1Hz': maketimer (
            1,
            func {
                data.wow = getprop('/gear/gear/wow');
                data.lat = getprop('/position/latitude-deg');
                data.lon = getprop('/position/longitude-deg');
            }
        ),
    },
    listeners : {},
};

var zkv = cdi = radios = alerts = infos = cursors = afcs = eis = nil;

var init_props = func {
    zkv = props.globals.getNode('/instrumentation/zkv1000',1);
    foreach (var d; zkv.getChildren())
        if (d.getNode('status') != nil)
            flightdeck[d.getName()] = nil;
    zkv.getNode('emission',1).setDoubleValue(0.5);
    zkv.getNode('body-emission',1).setDoubleValue(0.0);
    zkv.getNode('body-texture',1).setValue('');
    zkv.getNode('display-brightness-norm',1).setValue(0.5);

    radios = zkv.getNode('radios', 1);
    radios.getNode('nav1-selected',1).setIntValue(0);
    radios.getNode('nav1-standby',1).setIntValue(0);
    radios.getNode('nav2-selected',1).setIntValue(0);
    radios.getNode('nav2-standby',1).setIntValue(0);
    radios.getNode('nav-tune',1).setIntValue(0);
    radios.getNode('nav-freq-mhz',1).alias('/instrumentation/nav/frequencies/standby-mhz');
    radios.getNode('comm1-selected',1).setIntValue(1);
    radios.getNode('comm2-selected',1).setIntValue(0);
    radios.getNode('comm-tune',1).setIntValue(0);
    radios.getNode('comm-freq-mhz',1).alias('/instrumentation/comm/frequencies/standby-mhz');
    radios.getNode('xpdr-mode',1).setValue('GND');
    radios.getNode('brg1-source',1).setValue('OFF');
    radios.getNode('brg2-source',1).setValue('OFF');

    cdi = zkv.getNode('cdi', 1);
    cdi.getNode('source', 1).setValue('OFF');
    cdi.getNode('no-flag', 1).setBoolValue(0);
    cdi.getNode('FROM-flag', 1).alias('no-flag');
    cdi.getNode('TO-flag', 1).alias('no-flag');
    cdi.getNode('course', 1);
    cdi.getNode('course-deflection', 1);
    cdi.getNode('radial', 1);
    cdi.getNode('in-range', 1);

    alerts = zkv.getNode('alerts',1);
    alerts.getNode('traffic-proximity',1).setIntValue(0);
    alerts.getNode('marker-beacon', 1).setIntValue(0);
    alerts.getNode('warning', 1).setBoolValue(0);
    alerts.getNode('alert', 1).setBoolValue(0);
    alerts.getNode('message', 1).setValue('');
    foreach (var v; ['Vx', 'Vy', 'Vr', 'Vglide', 'Vne']) {
        var speed = getprop('/instrumentation/zkv1000/alerts/' ~ v);
        data[v] = speed != nil ? speed : 9999;
    }
    var aoa = getprop('/instrumentation/zkv1000/alerts/stall-aoa');
    data['stall-aoa'] = (aoa == nil or aoa == 0) ? 9999 : aoa;
    aoa = getprop('/instrumentation/zkv1000/alerts/approach-aoa');
    if (aoa != nil)
        data['approach-aoa'] = aoa;

    afcs = zkv.getNode('afcs',1);
    afcs.getNode('fd-bars-visible',1).setBoolValue(0);
    afcs.getNode('alt-bug-visible',1).setBoolValue(0);
    afcs.getNode('heading-bug-deg',1).setDoubleValue(getprop('/orientation/heading-magnetic-deg'));
    afcs.getNode('target-pitch-deg',1).setDoubleValue(0.0);
    afcs.getNode('selected-alt-ft',1).setIntValue(2000);
    afcs.getNode('selected-alt-ft-diff',1).setDoubleValue(0.0);
    afcs.getNode('selected-ias-kt-diff',1).setDoubleValue(0.0);
    afcs.getNode('vertical-speed-fpm',1).setDoubleValue(0.0);
    afcs.getNode('roll-armed', 1).setBoolValue(0);
    afcs.getNode('pitch-armed', 1).setBoolValue(0);
    afcs.getNode('roll-armed-mode-text',1).setValue('');
    afcs.getNode('roll-active-mode-text',1).setValue('');
    afcs.getNode('roll-armed-mode',1).setIntValue(0);
    afcs.getNode('roll-active-mode',1).setIntValue(0);
    afcs.getNode('roll-active-mode-blink',1).setBoolValue(0);
    afcs.getNode('pit-armed-mode-text',1).setValue('');
    afcs.getNode('pit-active-mode-text',1).setValue('');
    afcs.getNode('pit-armed-mode',1).setIntValue(0);
    afcs.getNode('pit-active-mode',1).setIntValue(0);
    afcs.getNode('pit-active-mode-blink',1).setBoolValue(0);
    afcs.getNode('route',1);

    eis = zkv.getNode('eis',1);
    eis.getNode('fuel-qty-at-start', 1).setValue(
        getprop('/consumables/fuel/tank/level-gal_us')
      + getprop('/consumables/fuel/tank/level-gal_us'));

    var tiles_defaults = {
        # see https://www.wikimedia.org/wiki/Maps
        server: 'maps.wikimedia.org',
        type:   'osm-intl',
        apikey: '',
        format: 'png',
        template: 'https://{server}/{type}/{z}/{x}/{y}.{format}{apikey}',
    };
    foreach (var v; keys(tiles_defaults)) {
        var val = getprop('/sim/online-tiles-' ~ v);
        data['tiles-' ~ v] = val != nil ? val : tiles_defaults[v];
    }

    props.globals.getNode('/instrumentation/transponder/id-code',1).setIntValue(1200);
    props.globals.getNode('/instrumentation/transponder/serviceable',1).setBoolValue(1);
    props.globals.getNode('/autopilot/settings/heading-bug-deg', 1).alias('/instrumentation/zkv1000/afcs/heading-bug-deg');
    props.globals.getNode('/autopilot/settings/target-altitude-ft',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/settings/target-speed-kt',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/settings/vertical-speed-fpm',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/internal/target-pitch-deg',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/internal/flc-altitude-pitch-deg',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/internal/flc-airspeed-pitch-deg',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/internal/target-roll-deg',1).setDoubleValue(0.0);
    props.globals.getNode('/autopilot/locks/pitch',1).setValue('');
    props.globals.getNode('/autopilot/locks/roll',1).setValue('');
    props.globals.getNode('/autopilot/locks/passive-mode', 1).setIntValue(1);

    data.zkv1000_reldir = io.dirname(getprop('/nasal/zkv1000/file'));
    data.zkv1000_dir = string.normpath(
            io.dirname(getprop('/sim/aircraft-dir'))
            ~ '/'
            ~ string.replace(data.zkv1000_reldir, split('/', data.zkv1000_reldir)[0], '')
        ) ~ '/';
}

var load_nasal = func {
    var nasal_dir = data.zkv1000_dir ~ 'Nasal/';
    for (var i = 0; i < size(files_to_load); i += 1)
        io.load_nasal(nasal_dir ~ files_to_load[i], 'zkv1000');
    files_to_load = nil;
}

var load_multikey = func {
    fgcommand('loadxml', props.Node.new({
        'filename': data.zkv1000_dir ~ 'Systems/multikey.xml',
        'targetnode': '/input/keyboard/'
    }));
    multikey.init();
}

var zkv1000_init = func {
    removelistener(init);
    init_props();
    load_multikey();
    load_nasal();
    print('zkv1000 loaded');
}

var init = setlistener('/sim/signals/fdm-initialized', zkv1000_init, 0, 0);
