var m803_timer = nil;

var M803 = props.globals.initNode("/instrumentation/M803");
var first_line_mode = M803.initNode("first-line", "E", "STRING");
var second_line_mode = M803.initNode("second-line-mode", "UT", "STRING");
var second_line = M803.initNode("second-line", "00:00", "STRING");

var utc_hour = props.globals.getNode("/sim/time/utc/hour", 1);
var utc_min = props.globals.getNode("/sim/time/utc/minute", 1);
var loc_hour = props.globals.getNode("/sim/time/local/hours", 1);

var update_m803 = func () {
	var slm = second_line_mode.getValue();
	if( slm == "UT" ) {
		second_line.setValue( sprintf("%02d", utc_hour.getValue()) ~ ":" ~ sprintf("%02d", utc_min.getValue()) );
	} else if ( slm == "LT" ) {
		second_line.setValue( sprintf("%02d", loc_hour.getValue()) ~ ":" ~ sprintf("%02d", utc_min.getValue()) );
	} else {
		second_line.setValue("nil");
	}
}


setlistener("/sim/signals/fdm-initialized", func {
	m803_timer = maketimer(0.1,update_m803);
	m803_timer.start();
	print("M803 initialized");
});

setlistener("/instrumentation/M803/serviceable", func(i) {
	if(i.getValue() != 1){
		m803_timer.stop();
	}else if(m803_timer.isRunning == 0){
		m803_timer.start();
	}
});
