#########################################################
############## General initializers #####################
#########################################################
#                                                        DEFA 552 A
var l_gun_ammo_count="ai/submodels/submodel[0]/count";
var r_gun_ammo_count="ai/submodels/submodel[1]/count";
#                                                        AIM-9 sidewinder (unguided)
var l_roc_ammo_count="ai/submodels/submodel[2]/count";
var r_roc_ammo_count="ai/submodels/submodel[3]/count";
#                                                        AN 52 bomb
var c_bom_ammo_count="ai/submodels/submodel[4]/count";

#########################################################
##################### reload guns #######################
#########################################################
#Guns generally cannot be reloaded in flight.  It requires landing,
#stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  groundspeed=getprop("velocities/groundspeed-kt");
  engine_rpm=getprop("engines/engine/rpm");

  #only allow it if on ground, stopped OR if it's already set to unlimited mode
  if ( ( groundspeed < 5 and engine_rpm < 5 ) or getprop ( r_gun_ammo_count)== -1 ) {

    #                                           DEFA 552 A
    setprop ( l_gun_ammo_count, 125);
    setprop ( r_gun_ammo_count, 125);
    #                                           AIM-9 sidewinder (unguided)
    setprop ( l_roc_ammo_count, 1);
    setprop ( r_roc_ammo_count, 1);
    #                                           AN 52 bomb
    setprop ( c_bom_ammo_count, 1);

    gui.popupTip ("Guns reloaded--125 rounds in each gun.", 5)
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5)
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
#For testing only, of course!

unlimited_guns = func {

  groundspeed=getprop("velocities/groundspeed-kt");
  engine_rpm=getprop("engines/engine/rpm");

  #                                           DEFA 552 A
  setprop ( l_gun_ammo_count, -1);
  setprop ( r_gun_ammo_count, -1);
  #                                           AIM-9 sidewinder (unguided)
  setprop ( l_roc_ammo_count, -1);
  setprop ( r_roc_ammo_count, -1);
  #                                           AN 52 bomb
  setprop ( c_bom_ammo_count, -1);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7)
}
#########################################################
############ Cannon impact messages #####################
#########################################################
var hits_count = 0;
var hit_timer  = nil;
var hit_callsign = "";

var Mp = props.globals.getNode("ai/models");
var valid_mp_types = {
  multiplgunsayer: 1, tanker: 1, aircraft: 1, ship: 1, groundvehicle: 1,
};

# Find a MP aircraft close to a given point (code from the Mirage 2000)
var findmultiplayer = func(targetCoord, dist) {

  if (targetCoord == nil) {
    return nil;
  }

  var raw_list = Mp.getChildren();
  var SelectedMP = nil;
  foreach(var c ; raw_list) {
    var is_valid = c.getNode("valid");
    if (is_valid == nil or !is_valid.getBoolValue()) {
      continue;
    }

    var type = c.getName();

    var position = c.getNode("position");
    var name = c.getValue("callsign");
    if (name == nil or name == "") {
      # fallback, for some AI objects
      var name = c.getValue("name");
    }
    if (position == nil or name == nil or name == "" or !contains(valid_mp_types, type)) {
      continue;
    }

    var lat = position.getValue("latitude-deg");
    var lon = position.getValue("longitude-deg");
    var elev = position.getValue("altitude-ft") * FT2M;

    if (lat == nil or lon == nil or elev == nil) {
      continue;
    }

    MpCoord = geo.Coord.new().set_latlon(lat, lon, elev);
    var tempoDist = MpCoord.direct_distance_to(targetCoord);
    if (dist > tempoDist) {
      dist = tempoDist;
      SelectedMP = name;
    }
  }
  return SelectedMP;
}

var impact_listener = func {

  var ballistic_name = props.globals.getNode("/ai/models/model-impact").getValue();
  var ballistic = props.globals.getNode(ballistic_name, 0);
  if (ballistic != nil and ballistic.getName() != "munition") {
    var typeNode = ballistic.getNode("impact/type");
    if (typeNode != nil and typeNode.getValue() != "terrain") {
      var lat = ballistic.getNode("impact/latitude-deg").getValue();
      var lon = ballistic.getNode("impact/longitude-deg").getValue();
      var elev = ballistic.getNode("impact/elevation-m").getValue();
      var impactPos = geo.Coord.new().set_latlon(lat, lon, elev);
      var target = findmultiplayer(impactPos, 80);

      if (target != nil) {
        var typeOrd = "50 BMG";               #ballistic.getNode("name").getValue();
        if (target == hit_callsign) {
          # Previous impacts on same target
          hits_count += 1;
        } else {
          if (hit_timer != nil) {
            # Previous impacts on different target, flush them first
            hit_timer.stop();
            hitmessage(typeOrd);
          }
          hits_count = 1;
          hit_callsign = target;
          hit_timer = maketimer(1, func {hitmessage(typeOrd);});
          hit_timer.singleShot = 1;
          hit_timer.start();
        }
      }
    }
  }
}

var hitmessage = func(typeOrd) {

  #print("inside hitmessage");
  var phrase = typeOrd ~ " hit: " ~ hit_callsign ~ ": " ~ hits_count ~ " hits";
  if (getprop("payload/armament/msg")) {
    #armament.defeatSpamFilter(phrase);
    var msg = notifications.ArmamentNotification.new("mhit", 4, -1*(damage.shells[typeOrd][0]+1));
    msg.RelativeAltitude = 0;
    msg.Bearing = 0;
    msg.Distance = hits_count;
    msg.RemoteCallsign = hit_callsign;
    notifications.hitBridgedTransmitter.NotifyAll(msg);
    damage.damageLog.push("You hit "~hit_callsign~" with "~typeOrd~", "~hits_count~" times.");
  } else {
    setprop("/sim/messages/atc", phrase);
  }
  hit_callsign = "";
  hit_timer = nil;
  hits_count = 0;
}

# setup impact listener
setlistener("ai/models/model-impact", impact_listener, 0, 0);
