var nasal_dir = getprop("/sim/fg-root") ~ "/Aircraft/Instruments-3d/FG1000/Nasal/";
var aircraft_dir = getprop("/sim/aircraft-dir");

io.load_nasal(nasal_dir ~ 'FG1000.nas', "fg1000");
io.load_nasal(aircraft_dir ~ '/Nasal/Interfaces/C208BInterfaceController.nas', "fg1000");

var interfaceController = fg1000.C208BInterfaceController.getOrCreateInstance();
interfaceController.start();


io.load_nasal(aircraft_dir ~ '/Nasal/EIS/EIS-C208B.nas', "fg1000");
io.load_nasal(aircraft_dir ~ '/Nasal/EIS/EISController.nas', "fg1000");
io.load_nasal(aircraft_dir ~ '/Nasal/EIS/EISStyles.nas', "fg1000");
io.load_nasal(aircraft_dir ~ '/Nasal/EIS/EISOptions.nas', "fg1000");

# This is the class in EIS-C208B.nas, loaded above.
var EIS_Class = fg1000.EISC208B;

# Create the FG1000 using custom EIS Class, and the appropriate .svg file.
var fg1000system = fg1000.FG1000.getOrCreateInstance(EIS_Class:EIS_Class, EIS_SVG: "Nasal/EIS/EIS-C208B.svg");

# Create a PFD as devices 1 and 3, MFD as device 2
fg1000system.addPFD(index:1);
fg1000system.addMFD(index:2);
fg1000system.addPFD(index:3);

# Map the devices to placement objects Screen{i}, in this case Screen1, Screen2 and Screen3
fg1000system.display(index:1);
fg1000system.display(index:2);
fg1000system.display(index:3);

# Show the devices
fg1000system.show(index:1);
fg1000system.show(index:2);
fg1000system.show(index:3);

# ref. https://quizlet.com/242584091/cessna-caravan-208b-v-speeds-flash-cards/
fg1000system.getConfigStore().set("Vr", 70);
fg1000system.getConfigStore().set("Vx", 72);
fg1000system.getConfigStore().set("Vy", 104);
fg1000system.getConfigStore().set("Vglide", 95);
fg1000system.getConfigStore().set("Vne", 175);

# Switch the FG1000 on/off depending on power.
setlistener("/systems/electrical/outputs/pfd[0]", func(n) {
	if (n.getValue() > 9) {
		fg1000system.show(index:1);
	} else {
		fg1000system.hide(index:1);
	}
}, 0, 0);
setlistener("/systems/electrical/outputs/mfd", func(n) {
	if (n.getValue() > 9) {
		fg1000system.show(index:2);
	} else {
		fg1000system.hide(index:2);
	}
}, 0, 0);
setlistener("/systems/electrical/outputs/pfd[1]", func(n) {
	if (n.getValue() > 9) {
		fg1000system.show(index:3);
	} else {
		fg1000system.hide(index:3);
	}
}, 0, 0);

# Control the backlighting of the bezel based on the avionics light knob
#setlistener("/controls/lighting/avionics-lights-norm", func(n) {
#	if (getprop("/systems/electrical/outputs/fg1000") > 5.0) {
#		setprop("/instrumentation/FG1000/Lightmap", n.getValue());
#	} else {
#		setprop("/instrumentation/FG1000/Lightmap", 0.0);
#	}
#}, 0, 0);
