var steady_sec = props.globals.getNode("/sim/time/steady-clock-sec",	1);

props.globals.initNode("/instrumentation/xflighttech/ap",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/cruise",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/home",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/home-lat",0.0,"DOUBLE");
props.globals.initNode("/instrumentation/xflighttech/home-lon",0.0,"DOUBLE");
props.globals.initNode("/instrumentation/xflighttech/home-distance",0.0,"DOUBLE");
props.globals.initNode("/instrumentation/xflighttech/home-but-last-push-time",0.0,"DOUBLE");
props.globals.initNode("/instrumentation/xflighttech/home-flash",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/nav",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/stab",0,"BOOL");
props.globals.initNode("/instrumentation/xflighttech/but-pos[0]",0,"BOOL");

var push_ap = func {
	var state = getprop("/instrumentation/xflighttech/ap") or 0;
	if(state == 1){
		setprop("/instrumentation/xflighttech/ap", 0);
		setprop("/instrumentation/xflighttech/cruise", 0);
		setprop("/instrumentation/xflighttech/home", 0);
		setprop("/instrumentation/xflighttech/nav", 0);
		setprop("/instrumentation/xflighttech/stab", 0);
		setprop("/autopilot/locks/heading", "");
		setprop("/autopilot/locks/altitude", "");
		setprop("/autopilot/locks/speed", "");
		setprop("/electrical-flight-events/start-event",0);
		timer_calcWay.stop();
		setprop("/instrumentation/xflighttech/home-distance",0.0);
		setprop("/instrumentation/xflighttech/home-flash",0);
	}else{
		if(getprop("/autopilot/locks/passive-mode") == 1){
			gui.popupTip("The route manager has been switched off.");
			setprop("/autopilot/locks/passive-mode",0);
			setprop("/autopilot/route-manager/active",0);
		}
    	setprop("/instrumentation/xflighttech/ap", 1);
		setprop("/instrumentation/xflighttech/cruise", 0);
		setprop("/instrumentation/xflighttech/home", 0);
		setprop("/instrumentation/xflighttech/nav", 0);
		setprop("/instrumentation/xflighttech/stab", 0);
		setprop("/autopilot/locks/heading", "");
		setprop("/autopilot/locks/altitude", "");
		setprop("/autopilot/locks/speed", "");
		timer_calcWay.start();
	}
}

# called from the yoke button
var push_speed = func {
	var state = getprop("/autopilot/locks/speed") or "";
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;
	if(ap_on == 1){
		if(state == "speed-with-throttle"){
	    setprop("/autopilot/locks/speed", "");
		}else{
			if(getprop("gear/gear[1]/position-norm") == 0){
	    	setprop("/autopilot/locks/speed", "speed-with-throttle");
			}
		}
	}
}

var push_stab = func {
	var state = getprop("/instrumentation/xflighttech/stab") or 0;
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;
	if(ap_on == 1){
		if(state == 1){
			setprop("/instrumentation/xflighttech/stab", 0);
			setprop("/autopilot/locks/heading", "");
			setprop("/autopilot/locks/altitude", "");
		}else{
	    	setprop("/instrumentation/xflighttech/stab", 1);
			setprop("/autopilot/locks/heading", "wing-leveler");
			setprop("/instrumentation/xflighttech/cruise", 0);
			setprop("/instrumentation/xflighttech/nav", 0);
			setprop("autopilot/locks/passive-mode", 0);
			setprop("/autopilot/locks/altitude", "");
			setprop("autopilot/route-manager/active", 0);
			setprop("/instrumentation/xflighttech/home-flash",0);
			setprop("/instrumentation/xflighttech/home",0);
		}
	}
}

var push_cruise = func {
	var state = getprop("/instrumentation/xflighttech/cruise") or 0;
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;
	if(ap_on == 1){
		if(state == 1){
			setprop("/instrumentation/xflighttech/cruise", 0);
			setprop("/autopilot/locks/heading", "");
			setprop("/autopilot/locks/altitude", "");
		}else{
			setprop("/autopilot/settings/heading-bug-deg", getprop("/orientation/heading-deg") or 0);
			setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
	    	setprop("/instrumentation/xflighttech/cruise", 1);
			setprop("/instrumentation/xflighttech/stab", 0);
			setprop("/instrumentation/xflighttech/nav", 0);
			setprop("/autopilot/locks/heading", "dg-heading-hold");
			setprop("/autopilot/locks/altitude", "altitude-hold");
			setprop("autopilot/locks/passive-mode", 0);
			setprop("autopilot/route-manager/active", 0);
			setprop("/instrumentation/xflighttech/home-flash",0);
			setprop("/instrumentation/xflighttech/home",0);
		}
	}
}

var push_home = func (mode){
	var state = getprop("/instrumentation/xflighttech/home") or 0;
	var tlat = getprop("/instrumentation/xflighttech/home-lat") or 0;
	var tlon = getprop("/instrumentation/xflighttech/home-lon") or 0;
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;
	var time = steady_sec.getDoubleValue();

	if(ap_on == 1){

		if(mode == "press"){
			setprop("/instrumentation/xflighttech/home-but-last-push-time", time);
		}else{
			# del memory home lat lon after 1.5 sec push_home mode-up
			var lt = getprop("/instrumentation/xflighttech/home-but-last-push-time");
			var diff = time - lt;
			if(diff < 1.5){
				if(tlat == 0 and tlon == 0){
					setprop("/instrumentation/xflighttech/home-lat", getprop("/position/latitude-deg") or 0);
					setprop("/instrumentation/xflighttech/home-lon", getprop("/position/longitude-deg") or 0);
				}
			}else{
				setprop("/instrumentation/xflighttech/home-lat", 0);
				setprop("/instrumentation/xflighttech/home-lon", 0);
			}

			if(tlat != 0 and tlon != 0){
				if(state == 1){
					setprop("/instrumentation/xflighttech/home", 0);
					setprop("/instrumentation/xflighttech/home-flash",0);
					setprop("/autopilot/settings/heading-bug-deg", 0);
			    	setprop("/instrumentation/xflighttech/cruise", 0);
					setprop("/instrumentation/xflighttech/stab", 0);
					setprop("/instrumentation/xflighttech/nav", 0);
					setprop("/autopilot/locks/heading", "");
					setprop("/autopilot/locks/altitude", "");
				}else{
					setprop("/instrumentation/xflighttech/home", 1);
					setprop("/autopilot/settings/heading-bug-deg", getprop("/orientation/heading-deg") or 0);
					setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
					setprop("/instrumentation/xflighttech/cruise", 0);
					setprop("/instrumentation/xflighttech/stab", 0);
					setprop("/autopilot/locks/heading", "");
					setprop("/autopilot/locks/altitude", "");
					setprop("/instrumentation/xflighttech/nav", 0);
					setprop("autopilot/locks/passive-mode", 0);
					setprop("autopilot/route-manager/active", 0);
				}
			}else{
				setprop("/autopilot/settings/heading-bug-deg", getprop("/orientation/heading-deg") or 0);
				setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
				setprop("/instrumentation/xflighttech/cruise", 0);
				setprop("/instrumentation/xflighttech/stab", 0);
				setprop("/autopilot/locks/heading", "");
				setprop("/autopilot/locks/altitude", "");
				setprop("/instrumentation/xflighttech/home", 0);
			}
		}
	}else{
		setprop("/autopilot/settings/heading-bug-deg", 0);
		setprop("/autopilot/settings/target-altitude-ft", 0);
		setprop("/instrumentation/xflighttech/cruise", 0);
		setprop("/instrumentation/xflighttech/stab", 0);
		setprop("/autopilot/locks/heading", "");
		setprop("/autopilot/locks/altitude", "");
		setprop("/instrumentation/xflighttech/home", 0);
		setprop("/instrumentation/xflighttech/nav", 0);
		setprop("autopilot/locks/passive-mode", 0);
	}
}

var push_nav = func {
	var state = getprop("/instrumentation/xflighttech/nav") or 0;
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;
	if(ap_on == 1){
		if(state == 1){
			setprop("/instrumentation/xflighttech/nav", 0);
			setprop("/autopilot/locks/passive-mode", 0);
			setprop("/autopilot/locks/altitude", "");
			setprop("/autopilot/locks/heading", "");
			# not a good idea... we have no chance to change the altitude during test. Stop it in iPad.
			#if(getprop("/electrical-flight-events/start-event") == 1 and getprop("/electrical-flight-events/calculate-event") == 1){
			#	setprop("/electrical-flight-events/start-event",0);
			#}
		}else{
			if (getprop("/autopilot/route-manager/active") == 1){
				setprop("/autopilot/locks/heading", "true-heading-hold");
		    	setprop("/instrumentation/xflighttech/nav", 1);
				setprop("/autopilot/locks/passive-mode", 1);
				setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
				setprop("/autopilot/locks/altitude", "altitude-hold");
				setprop("/instrumentation/xflighttech/home-flash",0);
				setprop("/instrumentation/xflighttech/cruise", 0);
				setprop("/instrumentation/xflighttech/stab", 0);
				setprop("/instrumentation/xflighttech/home", 0);
			}elsif(getprop("/electrical-flight-events/calculate-event") == 1){
				setprop("/electrical-flight-events/start-event",1);
				setprop("/autopilot/settings/heading-bug-deg", getprop("/orientation/heading-deg") or 0);
				setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
				setprop("autopilot/route-manager/active", 0);
				setprop("/autopilot/locks/altitude", "altitude-hold");
				setprop("/autopilot/locks/heading", "dg-heading-hold");
				setprop("autopilot/locks/passive-mode", 0);
				setprop("/instrumentation/xflighttech/cruise", 0);
				setprop("/instrumentation/xflighttech/stab", 0);
				setprop("/instrumentation/xflighttech/home", 0);
				setprop("/instrumentation/xflighttech/nav", 1);

				var nm = getprop("/electrical-flight-events/distance/calc-nm");
				gui.popupTip("Follow the triangle route - "~nm~"nm!");
			}else{
				gui.popupTip("A route or triangular flight route must be active to activate this mode !");
			}
		}
	}
}

var calc_way_loop = func {
	var ap_on = getprop("/instrumentation/xflighttech/ap") or 0;

	if(ap_on == 1){
		var tlat = getprop("/instrumentation/xflighttech/home-lat") or 0;
		var tlon = getprop("/instrumentation/xflighttech/home-lon") or 0;
		if (getprop("autopilot/route-manager/active") == 1){
			# var rmdis = getprop("/autopilot/route-manager/distance-remaining-nm") or 0.0;
			# setprop("/instrumentation/xflighttech/home-distance",rmdis);
			setprop("/instrumentation/xflighttech/cruise", 0);
			setprop("/instrumentation/xflighttech/stab", 0);
			setprop("/instrumentation/xflighttech/home-flash",0);
			setprop("/instrumentation/xflighttech/home", 0);
			setprop("/instrumentation/xflighttech/nav", 0);
			setprop("/instrumentation/xflighttech/ap", 0);

			setprop("/autopilot/locks/heading", "true-heading-hold");
			setprop("/autopilot/locks/passive-mode", 1);
			setprop("/autopilot/settings/target-altitude-ft", getprop("/position/altitude-ft") or 0);
			setprop("/autopilot/locks/altitude", "altitude-hold");

			gui.popupTip("Routemanager not compatible with xflighttech-autopilot. Please use the flightgear menu.");
			timer_calcWay.stop();

		}elsif(getprop("/instrumentation/xflighttech/home") == 1){
			if(tlat != 0 and tlon != 0){
					var flat = getprop("/position/latitude-deg") or 0;
					var flon = getprop("/position/longitude-deg") or 0;
					var tlat = getprop("/instrumentation/xflighttech/home-lat") or 0;
					var tlon = getprop("/instrumentation/xflighttech/home-lon") or 0;
					setprop("/electrical-flight-events/start-event",0);

					var from = {lat: flat, lon: flon};
					var to = {lat: tlat, lon: tlon};
					var (course, dist) = courseAndDistance(from, to);

					setprop("/instrumentation/xflighttech/home-distance",dist);

					if(getprop("/instrumentation/xflighttech/home") == 1){
						setprop("/autopilot/settings/heading-bug-deg", course);
						setprop("/instrumentation/xflighttech/cruise", 0);
						setprop("/instrumentation/xflighttech/stab", 0);
						setprop("/autopilot/locks/heading", "dg-heading-hold");
						setprop("/autopilot/locks/altitude", "altitude-hold");
						if(dist < 3){
								if(getprop("/instrumentation/xflighttech/home-flash")){
									setprop("/instrumentation/xflighttech/home-flash",0);
								}else{
									setprop("/instrumentation/xflighttech/home-flash",1);
								}
						}

						#print("OK, wir versuchen, nach Hause zu finden");
						gui.popupTip("Mission completed. Let's go home.");
					}
			}else{
					# do nothing gui.popupTip("There is no target or home position set in AP.");
					setprop("/instrumentation/xflighttech/home-flash",0);
					#print("OK, wir werden niemals nach Hause finden.");
					gui.popupTip("We are lost. There are no home coordinates.");
			}

		}elsif(getprop("/electrical-flight-events/calculate-event") == 1 and getprop("/electrical-flight-events/start-event") == 1){
			#print("OK, folgen wir dem Dreieck");
			var wp = getprop("/electrical-flight-events/distance/wp") or 0;

			var flat = getprop("/position/latitude-deg") or 0;
			var flon = getprop("/position/longitude-deg") or 0;
			var tlat = getprop("/electrical-flight-events/distance/point["~wp~"]/lat") or 0;
			var tlon = getprop("/electrical-flight-events/distance/point["~wp~"]/lon") or 0;

			var wpAll = props.globals.getNode("/electrical-flight-events/distance").getChildren("point");
			var wps = size(wpAll);

			# during the test
			var from = {lat: flat, lon: flon};
			var to = {lat: tlat, lon: tlon};
			var (course, dist) = courseAndDistance(from, to);

			setprop("/instrumentation/xflighttech/home-distance",dist);
			# dis in nm
			if(dist < 0.6){
				if(wp == 2 and getprop("/electrical-flight-events/distance/distance-starttime") == 0){
					# start the distance test
					gui.popupTip("Distance-Flight-Mission started.");
					setprop("/electrical-flight-events/distance/distance-starttime", getprop("/sim/time/steady-clock-sec"));
					wp = -1;
				}

				wp += 1;
				if(wp >= wps){
					wp = 0;
					# finished the test, save the parameters
					gui.popupTip("Distance-Flight-Mission completed.");
					# needed time
					var thist = getprop("/sim/time/steady-clock-sec");
					var startt = getprop("/electrical-flight-events/distance/distance-starttime") or 0;
					var tft = thist - startt;

					var h = int(tft/3600);
					var hrest = math.mod(tft,3600);
					var mins = int(hrest/60);
					var secs = math.mod(hrest,60);
					
					# print(tft~" sec.");
					# calculate nm per hour
					var avspeedinkts = int(getprop("/electrical-flight-events/distance/nm")*3600/tft);
					# some data for the testinformations
					var chargement = getprop("/systems/accel-electrical/battery/battery-charge-percent") * 100;
					var windkts = getprop("environment/wind-speed-kt") or 0;
					var windfrom = getprop("environment/wind-from-heading-deg") or 0;
					var temp_c = getprop("environment/temperature-degc") or 0;
					var time_d =  getprop("sim/time/real/day") or 0;
					var time_m =  getprop("sim/time/real/month") or 0;
					var time_year =  getprop("sim/time/real/year") or 0;
					var time_y = time_year - 2000;
					var datestring = sprintf("%02d", time_d)~"."~sprintf("%02d", time_m)~"."~sprintf("%02d", time_y);
					var timestring = sprintf("%02d", h)~":"~sprintf("%02d", mins)~":"~sprintf("%02d", secs)~"TFT";
					var insane_sort = getprop("/electrical-flight-events/distance/nm")*1000 + avspeedinkts;

					# fill a list
					var disOther = props.globals.getNode("/electrical-flight-events/distance").getChildren("distance");
					var distrials = size(disOther);
					var speedtest_list = {};
					for(var i=0; i < distrials; i+=1){
						speedtest_list[i] = {s: getprop("/electrical-flight-events/distance/dis-sort["~i~"]"), d: getprop("/electrical-flight-events/distance/distance["~i~"]"),e: getprop("/electrical-flight-events/distance/dis-str["~i~"]"),etc: getprop("/electrical-flight-events/distance/dis-string["~i~"]")};
					}

					# write the data for this test to the list
					var infotext = "nm "~sprintf("%.0f", avspeedinkts)~"kts/av | "~sprintf("%.0f", chargement)~"% SoC | "~timestring;
					var moretext = "  "~sprintf("%.1f", temp_c)~"°C | Wind "~sprintf("%.0f", windkts)~"kts from "~sprintf("%.0f",windfrom)~" | "~datestring;
					speedtest_list[5] = {s: insane_sort,d: getprop("/electrical-flight-events/distance/nm"), e: infotext, etc: moretext};

					# sort the hash
					var sortedspeedtest_list = sort(keys(speedtest_list), func (a,b) { speedtest_list[b].s - speedtest_list[a].s;});
					pop(sortedspeedtest_list);  #cut the slowest test
					var sortnr = size(sortedspeedtest_list);

					# save the sorted tests
					if(sortedspeedtest_list != nil){
						for(var n=0; n < sortnr; n+=1){
							setprop("/electrical-flight-events/distance/dis-sort["~n~"]", speedtest_list[sortedspeedtest_list[n]].s);
							setprop("/electrical-flight-events/distance/distance["~n~"]", speedtest_list[sortedspeedtest_list[n]].d);
							setprop("/electrical-flight-events/distance/dis-str["~n~"]", speedtest_list[sortedspeedtest_list[n]].e);
							setprop("/electrical-flight-events/distance/dis-string["~n~"]", speedtest_list[sortedspeedtest_list[n]].etc);
						}
					}
					setprop("/electrical-flight-events/distance/distance-starttime",0);
				}
				# the next wp for calculation
				setprop("/electrical-flight-events/distance/wp", wp);
			}

			setprop("/autopilot/settings/heading-bug-deg", course);

		}else{
			#print("Weder eine Route, noch die Homeschleife, noch das Dreieck klappt!");
			if(tlat != 0 and tlon != 0){
				var flat = getprop("/position/latitude-deg") or 0;
				var flon = getprop("/position/longitude-deg") or 0;
				var tlat = getprop("/instrumentation/xflighttech/home-lat") or 0;
				var tlon = getprop("/instrumentation/xflighttech/home-lon") or 0;

				var from = {lat: flat, lon: flon};
				var to = {lat: tlat, lon: tlon};
				var (course, dist) = courseAndDistance(from, to);

				setprop("/instrumentation/xflighttech/home-distance",dist);
			}
		}

  	}else{
		setprop("/instrumentation/xflighttech/home-distance",0.0);
		setprop("/instrumentation/xflighttech/home-flash",0);
		setprop("/electrical-flight-events/calculate-event",0);
	}
}

timer_calcWay = maketimer(1.4, calc_way_loop);
