# Autostart based on Jet and turboprop system for piston engines
#
# BARANGER Emmanuel (04/2024)

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

var eng1fuelon = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon = func { setprop("/controls/engines/engine[1]/cutoff", 0); }
var eng3fuelon = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon = func { setprop("/controls/engines/engine[3]/cutoff", 0); }

var eng1fueloff = func {
  setprop("/controls/engines/engine[0]/cutoff", 1);
  setprop("/controls/engines/engine[0]/throttle", 0);
}
var eng2fueloff = func {
  setprop("/controls/engines/engine[1]/cutoff", 1);
  setprop("/controls/engines/engine[1]/throttle", 0);
}
var eng3fueloff = func {
  setprop("/controls/engines/engine[2]/cutoff", 1);
  setprop("/controls/engines/engine[2]/throttle", 0);
}
var eng4fueloff = func {
  setprop("/controls/engines/engine[3]/cutoff", 1);
  setprop("/controls/engines/engine[3]/throttle", 0);
}

var eng1starter = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng3starter = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter = func { setprop("/controls/engines/engine[3]/starter", 1); }

var eng1staroff = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2staroff = func { setprop("/controls/engines/engine[1]/starter", 0); }
var eng3staroff = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4staroff = func { setprop("/controls/engines/engine[3]/starter", 0); }

var eng1start = func {
  gui.popupTip("*** Engine start 1 left exterior ***");
  eng1fueloff();
  eng1starter();
  settimer(eng1fuelon, 2);
  settimer(eng1staroff, 4);
}

var eng2start = func {
  gui.popupTip("*** Engine start 2 left interior ***");
  eng2fueloff();
  eng2starter();
  settimer(eng2fuelon, 2);
  settimer(eng2staroff, 4);
}

var eng3start = func {
  gui.popupTip("*** Engine start 3 right interior ***");
  eng3fueloff();
  eng3starter();
  settimer(eng3fuelon, 2);
  settimer(eng3staroff, 4);
}

var eng4start = func {
  gui.popupTip("*** Engine start 4 right exterior ***");
  eng4fueloff();
  eng4starter();
  settimer(eng4fuelon, 2);
  settimer(eng4staroff, 4);
}

var engstart = func {
  settimer(eng1start, 2);
  settimer(eng4start, 6);
  settimer(eng2start, 10);
  settimer(eng3start, 14);
}

var engstop = func {
  settimer(eng3fueloff, 1);
  settimer(eng2fueloff, 2);
  settimer(eng4fueloff, 3);
  settimer(eng1fueloff, 4);
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    engstop();
  }
}
