##############
## Liveries ##
##############
aircraft.livery.init("Aircraft/HK36/Models/Liveries");

#######################
## Controls override ##
#######################
# key 's' calls to this function when it is pressed DOWN even if I overwrite the binding in the -set.xml file!
# fun fact: the key UP event can be overwriten!
controls.startEngine = func(v = 1) {
	# Only operate in non-walker mode ('s' is also bound to walk-backward)
	var view_name = getprop("/sim/current-view/name");
	if (view_name == getprop("/sim/view[110]/name") or view_name == getprop("/sim/view[111]/name")) {
		return;
	}
	if (getprop("/engines/engine[0]/running"))
	{
		setprop("/controls/switches/starter", 0);
		return;
	}
	else {
		setprop("/controls/switches/starter", v);
	}
};

#############################
## Gliding Instrumentation ##
#############################
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_5stv5_needle = Dampener.new(
	input: probe,
	dampening: 2.7,
	on_update: update_prop("/instrumentation/variometer/te-reading-mps"));

var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_5stv5_needle],
	enable: 1);
