##################################################################
####      hydraulic_loop.nas - ePilot                         ####
####                                                          ####
####    Main Hydraulic Loop                                   ####
####                                                          ####
##################################################################

var hydraulic_loop = func {

var battery_on = getprop("controls/electric/battery-switch");
var external_on = getprop("controls/electric/external-power");
var engine1_on = getprop("engines/engine[0]/running");
var engine2_on = getprop("engines/engine[1]/running");
var gen1_on = getprop("controls/electric/engine[0]/generator");
var gen2_on = getprop("controls/electric/engine[1]/generator");
var press = getprop("systems/hydraulic/mainsyspress");
#var subsyspress = getprop("systems/hydraulic/subsyspress");

    if (battery_on or external_on or (engine1_on and gen1_on) or (engine2_on and gen2_on)) {
      if (press == 0) {
        interpolate("systems/hydraulic/mainsyspress", 3000, 10);
        interpolate("systems/hydraulic/subsyspress", 1500, 10);
      }

    } else {
      if (press == 3000) {
        interpolate("systems/hydraulic/mainsyspress", 0, 10);
        interpolate("systems/hydraulic/subsyspress", 0, 10);
      }
    }

    settimer(hydraulic_loop, 2.1);

}

hydraulic_loop();
