# ==================================================
# If tower is on, hold position
# ==================================================

var path_to_tower_mp    = "sim/multiplay/generic/bool[1]";
var path_to_tower_local = "/controls/gear/brake-parking";

# tower down
var castTower = func {
  var agl = getprop("/position/gear-agl-m");
  if ( agl < 5.0 ) {
    var tower    = props.globals.getNode(path_to_tower_local, 1);
    var tower_mp = props.globals.getNode(path_to_tower_mp, 1);
    var towerLat = props.globals.getNode("/controls/gear/tower-lat", 1);
    var towerLon = props.globals.getNode("/controls/gear/tower-lon", 1);
    var lat      = props.globals.getNode("/position/latitude-deg", 1);
    var lon      = props.globals.getNode("/position/longitude-deg", 1);
    # set new position
    towerLat.setValue(lat.getValue());
    towerLon.setValue(lon.getValue());

    if (tower.getValue() == 1)  {
      screen.log.write("Tower is already ON!", 1.0, 0.7, 0.0);
    } else {
      tower.setValue(1);
      tower_mp.setValue(1);
      screen.log.write("Tower ON!", 1.0, 0.7, 0.0);
      holdPos();
    }
  } else {
    screen.log.write("Do not cast tower in flight!", 1.0, 0.0, 0.0);
  }
}

# tower up
var hoistTower = func {
  var tower    = props.globals.getNode(path_to_tower_local, 1);
  var tower_mp = props.globals.getNode(path_to_tower_mp, 1);
  tower.setValue(0);
  tower_mp.setValue(0);
  screen.log.write("Tower OFF", 1.0, 0.7, 0.0);
}

# this function will not end once she is startet at session.
# but if tower is up, she return at the first if - so ... ;-)
var holdPos = func {
  var tower = props.globals.getNode(path_to_tower_local, 1);
  if (tower.getValue() == 1 ) {
    var towerLat = props.globals.getNode("/controls/gear/tower-lat", 1);
    var towerLat = towerLat.getValue();
    setprop("/position/latitude-deg", towerLat);

    var towerLon = props.globals.getNode("/controls/gear/tower-lon", 1);
    var towerLon = towerLon.getValue();
    setprop("/position/longitude-deg", towerLon);
  }
  # Position updated at framerate time
  settimer(holdPos, 0);
}

redo = 1;

# if somebody want to try take of with tower, chains will ruptured
setlistener("/instrumentation/airspeed-indicator/true-speed-kt", func(as) {
  var as       = getprop("/instrumentation/airspeed-indicator/true-speed-kt");
  var tower    = props.globals.getNode(path_to_tower_local, 1);
  var tower_mp = props.globals.getNode(path_to_tower_mp, 1);
  # if (as > 27 and tower.getValue() == 1) {
  #   tower.setValue(0);
  #   tower_mp.setValue(0);
  #   screen.log.write("Tower chains ruptured!!", 1.0, 0.0, 0.0);
  # }
  if ( redo == 1 ) {
    var tmp = getprop("/position/gear-agl-m");
    if ( tmp != nil ) {
      hoistTower();
      castTower();
      redo = 0;
    }
  }
});
