# Test a canvas instrument

var DDU10_main = nil;
var DDU10_display = nil;

var DDU10 = props.globals.getNode("systems/accel-electrical/battery/engine-volts", 1);
var start_prop = props.globals.getNode("systems/accel-electrical/startsys", 1);
var calculated_rest_hours = props.globals.getNode("systems/accel-electrical/battery/crh", 0, "INT");			#	how long stay the battery
var calculated_rest_min = props.globals.getNode("systems/accel-electrical/battery/crm", 0, "INT");			#	how long stay the battery
var calculated_rest_sec = props.globals.getNode("systems/accel-electrical/battery/crs", 0, "INT");			#	how long stay the battery

var instrument_dir = "Aircraft/RR-ACCEL/Models/Cockpit/Instruments/ddu10-canvas/";

var canvas_DDU10_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "monoMMM_5.ttf";
		};


		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();

		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)",
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var starter = start_prop.getBoolValue();

		if ( starter > 0.98 ) {
			DDU10_main.page.show();
		} else {
			DDU10_main.page.hide();
		}

    var wgpu = getprop("aircraft/settings/show-canvas-ddu10") or 0;
		if(wgpu == 1){
			settimer(func me.update(), 0.02);
		}else{
      DDU10_main.page.hide();
    }
	},
};

var canvas_DDU10_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_DDU10_main , canvas_DDU10_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ddu10.volts","ddu10.cell.1","ddu10.cell.2","ddu10.cell.3",
            "c1.b1","c1.b2","c1.b3","c1.b4","c1.b5","c1.b6","c2.b1","c2.b2","c2.b3","c2.b4","c2.b5","c2.b6","c3.b1","c3.b2","c3.b3","c3.b4","c3.b5","c3.b6",
            "text.c1b1","text.c1b2","text.c1b3",
            "text.c2b1","text.c2b2","text.c2b3",
            "text.c3b1","text.c3b2","text.c3b3",
            "ddu10.kw","bg.kw","rest.hour","rest.min", "rest.sec"];
	},
	update: func() {

    #Voltage Power
		var DDU10_val = DDU10.getValue();

    me["rest.hour"].setText(sprintf("%02d", calculated_rest_hours.getValue()));
    me["rest.min"].setText(sprintf("%02d", calculated_rest_min.getValue()));
    me["rest.sec"].setText(sprintf("%02d", calculated_rest_sec.getValue()));

		me["ddu10.volts"].setText(sprintf("%4d", math.round(DDU10_val)));
		me["ddu10.cell.1"].setText(sprintf("%3d", getprop("systems/accel-electrical/battery/cell[0]/charge")*100));
		me["ddu10.cell.2"].setText(sprintf("%3d", getprop("systems/accel-electrical/battery/cell[1]/charge")*100));
		me["ddu10.cell.3"].setText(sprintf("%3d", getprop("systems/accel-electrical/battery/cell[2]/charge")*100));

		# only diffuse calculation to show not the same charge param for every block and cell - nothing
    var tc1b1 = getprop("systems/accel-electrical/battery/cell[0]/pack[0]/charge");
    var tc1b2 = getprop("systems/accel-electrical/battery/cell[0]/pack[1]/charge");
    var tc1b3 = getprop("systems/accel-electrical/battery/cell[0]/pack[2]/charge");

    var tc2b1 = getprop("systems/accel-electrical/battery/cell[1]/pack[0]/charge");
    var tc2b2 = getprop("systems/accel-electrical/battery/cell[1]/pack[1]/charge");
    var tc2b3 = getprop("systems/accel-electrical/battery/cell[1]/pack[2]/charge");

    var tc3b1 = getprop("systems/accel-electrical/battery/cell[2]/pack[0]/charge");
    var tc3b2 = getprop("systems/accel-electrical/battery/cell[2]/pack[1]/charge");
    var tc3b3 = getprop("systems/accel-electrical/battery/cell[2]/pack[2]/charge");

    me["text.c1b1"].setText(sprintf("%3d", math.round(tc1b1*100)));
    me["text.c1b2"].setText(sprintf("%3d", math.round(tc1b2*100)));
    me["text.c1b3"].setText(sprintf("%3d", math.round(tc1b3*100)));

    me["text.c2b1"].setText(sprintf("%3d", math.round(tc2b1*100)));
    me["text.c2b2"].setText(sprintf("%3d", math.round(tc2b2*100)));
    me["text.c2b3"].setText(sprintf("%3d", math.round(tc2b3*100)));

    me["text.c3b1"].setText(sprintf("%3d", math.round(tc3b1*100)));
    me["text.c3b2"].setText(sprintf("%3d", math.round(tc3b2*100)));
    me["text.c3b3"].setText(sprintf("%3d", math.round(tc3b3*100)));

    # diagramm
    me["c1.b1"].setTranslation(0,(1-tc1b1)*200);
		me["c1.b2"].setTranslation(0,(1-tc1b1)*200);
		me["c1.b3"].setTranslation(0,(1-tc1b2)*200);
		me["c1.b4"].setTranslation(0,(1-tc1b2)*200);
		me["c1.b5"].setTranslation(0,(1-tc1b3)*200);
		me["c1.b6"].setTranslation(0,(1-tc1b3)*200);

		me["c2.b1"].setTranslation(0,(1-tc2b1)*200);
		me["c2.b2"].setTranslation(0,(1-tc2b1)*200);
		me["c2.b3"].setTranslation(0,(1-tc2b2)*200);
		me["c2.b4"].setTranslation(0,(1-tc2b2)*200);
		me["c2.b5"].setTranslation(0,(1-tc2b3)*200);
		me["c2.b6"].setTranslation(0,(1-tc2b3)*200);

		me["c3.b1"].setTranslation(0,(1-tc3b1)*200);
		me["c3.b2"].setTranslation(0,(1-tc3b1)*200);
		me["c3.b3"].setTranslation(0,(1-tc3b2)*200);
		me["c3.b4"].setTranslation(0,(1-tc3b2)*200);
		me["c3.b5"].setTranslation(0,(1-tc3b3)*200);
		me["c3.b6"].setTranslation(0,(1-tc3b3)*200);


		var power_kw = getprop("systems/accel-electrical/fake-outputs/kw") or 0;
		var power_deg = power_kw/750 * 85;

		me["ddu10.kw"].setText(sprintf("%2d", math.round(power_kw)));
		me["bg.kw"].setRotation(power_deg*D2R);

    var wgpu = getprop("aircraft/settings/show-canvas-ddu10") or 0;
		if(wgpu == 1){
			settimer(func me.update(), 0.02);
		}
	}

};

setlistener("sim/signals/fdm-initialized", func {
	DDU10_display = canvas.new({
		"name": "DDU10",
		"size": [1024, 512],
		"view": [1024, 512],
		"mipmapping": 1
	});
	DDU10_display.addPlacement({"node": "display"});
	var groupMain = DDU10_display.createGroup();


	DDU10_main = canvas_DDU10_main.new(groupMain, instrument_dir~"DDU10_main.svg");

	DDU10_main.update();
	canvas_DDU10_base.update();
});

# if we go back from the weak gpu state
setlistener("aircraft/settings/show-canvas-ddu10", func(state) {
	var value = state.getValue();
	if(value == 1){
		DDU10_main.update();
		canvas_DDU10_base.update();
	}
});

var showDDU10 = func {
	var dlg = canvas.Window.new([330,165], "dialog").set("resize", 1);
	dlg.setCanvas(DDU10_display);
}
