######################################################################
###                                                                ###
###                Guns fire only if view is done                  ###
###                                                                ###
### BARANGER Emmanuel aka Helijah 04/10/2024                       ###
###                               03/01/2025                       ###
###                               26/01/2025                       ###
###                               02/02/2025 for B17               ###
###                               30/07/2025 for Ju 87             ###
###                               19/08/2025 for Bf 110            ###
###                               28/09/2025 for Bf Tu SB2bis M103 ###
######################################################################

#                                                        Guns
var n_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var n_gun2_ammo_count = "ai/submodels/submodel[1]/count";
var n_gun3_ammo_count = "ai/submodels/submodel[2]/count";
#                                                        MK-82 531 pound bomb
var n_bomb_ammo_count = "ai/submodels/submodel[3]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  var  groundspeed = getprop("velocities/groundspeed-kt");

  # only allow it if on ground or if it's already set to unlimited mode
  if ( groundspeed < 5 or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           Guns
    setprop( n_gun1_ammo_count, 400);
    setprop( n_gun2_ammo_count, 400);
    setprop( n_gun3_ammo_count, 400);
    #                                           MK-82 531 pound bomb
    setprop( n_bomb_ammo_count, 6);

    setprop("sim/multiplay/generic/int[11]", 0);

    gui.popupTip ("Guns reloaded--400 rounds in each gun.", 5)
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5)
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  var groundspeed = getprop("velocities/groundspeed-kt");

  #                                           Guns
  setprop( n_gun1_ammo_count, -1);
  setprop( n_gun2_ammo_count, -1);
  setprop( n_gun3_ammo_count, -1);
  #                                           MK-82 531 pound bomb
  setprop( n_bomb_ammo_count, 6);

  setprop("sim/multiplay/generic/int[11]", 0);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7)
}

fire_MG = func {
  var CurrentView = getprop("sim/current-view/view-number-raw");
  if ( CurrentView == 101 ) {
    # Rear gunner
    # var wpos = getprop("sim/model/door-positions/passenger/position-norm");
    var wpos = getprop("sim/multiplay/generic/float[1]");
    if (wpos == 1 ) {
      # setprop("/controls/armament/trigger1", 1);
      setprop("sim/multiplay/generic/int[13]", 1);
    }
  } elsif ( CurrentView == 102 ) {
    # Nose gunner
    # setprop("/controls/armament/trigger", 1);
    setprop("sim/multiplay/generic/int[10]", 1);
  }
}

stop_MG = func {
  # setprop("/controls/armament/trigger0", 0);
  setprop("sim/multiplay/generic/int[10]", 0);
  # setprop("/controls/armament/trigger1", 0);
  setprop("sim/multiplay/generic/int[13]", 0);
}
