var looptime = 0.1;
var throttle = "controls/engines/engine[0]/throttle";
var rpm = "engines/engine[0]/rpm-c";
var idle_rpm =700;
var maxRPM = 5400;
var eng_accel = 60;
var engon ="engines/engine[0]/running";
var leftwheelF= "controls/gear/gear[0]/throttle";
var rightwheelF= "controls/gear/gear[1]/throttle";
var leftwheelR= "controls/gear/gear[2]/throttle";
var rightwheelR= "controls/gear/gear[3]/throttle";
var difflockF= "controls/gear/axle[0]/difflock";
var difflockR= "controls/gear/axle[1]/difflock";
var fwd= "controls/gear/fourwd";
var aileron = "controls/flight/aileron";
var elevator = "controls/flight/elevator";
var mousesteer = "controls/flight/mousesteer";
var brake = "controls/gear/brake-left";
var ppitch = "controls/engines/engine[0]/propeller-pitch";
var current_gear = "controls/engines/engine[0]/gear";
var max_gear = 1;

var init = func {
		if (getprop("controls/engines/engine[0]/on-startup-running")) {
		magicstart();
		}
settimer(main_loop, looptime);
}

var main_loop = func {
  if (getprop (mousesteer) ) {
    elev = getprop (elevator);
    if (elev > 0 ) {
      setprop ( throttle, elev );
      setprop ( ppitch, elev);
      setprop ( brake, 0 );
    } else {
      setprop ( throttle, 0 );
      setprop ( brake, abs (elev) );
    }
  }
  if (engon) {
 #   print ("engine running");
  #  update_eng_state();
 #   update_transmission();
  }
  settimer(main_loop, looptime);
}


var shift_gear = func {
  var elev = getprop (elevator);
  var gear = getprop (current_gear);
    print ("gear: ", gear, " elev: ", elev);
    if (elev > 0.0 ) {
      if (gear < max_gear) {
        gear +=1;
        setprop (current_gear, gear );
        setprop ("sim/messages/pilot", gear ~". Gear");
      }  
    } else {
      if (gear > -1 ) {
        setprop (current_gear, gear - 1);
        setprop ("sim/messages/pilot", "Reverse");
      }  
    }

}

var magicstart = func {
		setprop (rpm, idle_rpm);
		setprop (engon, 1);
}

var reset_throttles = func {
  setprop ("controls/engines/engine[0]/throttle-r",0);
  setprop ("controls/engines/engine[0]/throttle-c",0);
}

#Listener

setlistener("controls/engines/engine[0]/gear",reset_throttles);

setlistener("/sim/signals/fdm-initialized",init);
